<?php
/* --------------------------------------------------------------
   TrackingCodeMapper.php 2020-03-09
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2019 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\TrackingCode\Repository;

use DateTime;
use Gambio\Admin\TrackingCode\Interfaces\TrackingCode;
use Gambio\Admin\TrackingCode\Model\TrackingCodeId;
use Gambio\Admin\TrackingCode\Model\TrackingCodeIds;
use Gambio\Admin\TrackingCode\TrackingCodeFactory;

/**
 * Class TrackingCodeMapper
 *
 * @package Gambio\Admin\TrackingCode\Repository
 */
class TrackingCodeMapper
{
    /**
     * @var TrackingCodeFactory
     */
    private $factory;
    
    
    /**
     * TrackingCodeMapper constructor.
     *
     * @param TrackingCodeFactory $factory
     */
    public function __construct(TrackingCodeFactory $factory)
    {
        $this->factory = $factory;
    }
    
    
    /**
     * @param array $data
     *
     * @return TrackingCode
     */
    public function mapTrackingCode(array $data): TrackingCode
    {
        $parcelServiceDetails = $this->factory->createParcelServiceDetails((int)$data['parcel_service_id'],
                                                                           $data['parcel_service_name'],
                                                                           $data['url'],
                                                                           $data['comment']);
        
        return $this->factory->createTrackingCode((int)$data['order_id'],
                                                  $data['tracking_code'],
                                                  (int)$data['language_id'],
                                                  $parcelServiceDetails,
                                                  (int)$data['orders_parcel_tracking_code_id'],
                                                  new DateTime($data['creation_date']));
    }
    
    
    /**
     * @param int[] $ids
     *
     * @return TrackingCodeIds
     */
    public function mapTrackingCodeIds(array $ids): TrackingCodeIds
    {
        $collection = [];
        foreach ($ids as $reference => $id) {
            $collection[$reference] = TrackingCodeId::create($id);
        }
        
        return TrackingCodeIds::createWithReferences($collection);
    }
}